<?php

defined('PF_VERSION') OR exit('Access denied');
define('PLUGIN_COMMENT', __('Comment', 'comment'));

class Comment_Plugin extends Pf_Plugin
{

    public $name = PLUGIN_COMMENT;
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'This is the Comment description';

    public function activate()
    {
        $db = Pf::database();
        $db->query("CREATE TABLE `pf_comments` (
                    `id` int(11) NOT NULL AUTO_INCREMENT,
                    `comment_author` varchar(128) NOT NULL,
                    `comment_email` varchar(128) NOT NULL,
                    `comment_url` varchar(255) NOT NULL,
                    `comment_content` varchar(500) NOT NULL,
                    `comment_created_date` datetime NOT NULL,
                    `comment_modified_date` datetime NOT NULL,
                    `comment_parent` int(11) NOT NULL,
                    `comment_user_id` int(11) NOT NULL,
                    `comment_key` varchar(50) NOT NULL,
                    `comment_status` tinyint(1) NOT NULL,
                    PRIMARY KEY (`id`)
                   ) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8");
    }

    public function deactivate()
    {
        $db = Pf::database();
        $db->query("DROP TABLE IF EXISTS pf_comments");
    }

    public function admin_init()
    {
        require_once ABSPATH . '/includes/common/plugin/utiles/pf-plugin-singleton.php';
        require_once abs_plugin_path(__FILE__) . '/comment/comment-config.php';
        require ABSPATH . '/includes/common/plugin/helpers/permission.php';
        if (plugin_check_acl(array(1, 2))) {
            $this->admin_menu('fa fa-comments', __('Comment', 'comment'), 'comment', 'plugin_comment_manager');
        }
    }

    function plugin_comment_manager()
    {
        $this->js('admin/themes/default/assets/bootstrap-notification/js/jquery/jquery.easing.1.3.js');
        $this->js('admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js');

        $this->css('comment/assets/comment.css', __FILE__);
        $this->js('comment/assets/bootbox.min.js', __FILE__);
        $this->js('includes/common/plugin/assets/base.js');
        $this->js('comment/assets/comment.js', __FILE__);
        require abs_plugin_path(__FILE__) . '/comment/index.php';
    }

    //Public
    public function public_init()
    {
        $shortcode = Pf::shortcode();
        $shortcode->add('comment', array($this, 'plugin_comment_public'));
    }

    function plugin_comment_public($atts, $content = null, $code = '')
    {
        $output = require abs_plugin_path(__FILE__) . '/comment/public/index.php';
        return $output;
    }

}
